#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// Quasi-Kleinian_Ring of CirclesMod01.fsh    by  Refurio   
//https://www.shadertoy.com/view/lf2fDG
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

////////////////////////////////
// view port
////////////////////////////////
vec2 center = vec2(0.,0.);
float radius = 1.2;
float angle = radians(0.);

////////////////////////////////
// complex arithmetic
////////////////////////////////
const float pi = radians(180.);
float arg(vec2 z) {
  return atan(z.y, z.x);
}
float abs2(vec2 z) {
  return z.x*z.x + z.y*z.y;
}
vec2 cmul(vec2 a, vec2 b) {
  return vec2(a.x*b.x-a.y*b.y, a.x*b.y+a.y*b.x);
}
// see my "Lambert w" shader for the full set.

////////////////////////////////
// coloring functions:
////////////////////////////////
// https://github.com/hughsk/glsl-hsv2rgb/blob/master/index.glsl
vec3 hsv(in vec3 c) {
    vec4 K = vec4(1.0, 2.0 / 3.0, 1.0 / 3.0, 3.0);
    vec3 p = abs(fract(c.xxx + K.xyz) * 6.0 - K.www);
    return c.z * mix(K.xxx, clamp(p - K.xxx, 0.0, 1.0), c.y);
}
vec3 hsv(float h, float s, float v) {
  return hsv(vec3(h, s, v));
}
vec3 phase(vec2 z) {
  return hsv(vec3(arg(z)/pi, 1., 1.));
}
vec3 axies(vec2 z) {
  float t = arg(z)/pi;
  float a = mod(2.*t+2., 2.)-1.;
  a = abs(2.*a)-1.;
  a = asin(a)/pi+.5;
  return vec3(a,a,a);
}
vec3 white = vec3(1.,1.,1.);
vec3 red = vec3(1.,0.,0.);
vec3 blue = vec3(0.3,0.3,1.);
vec3 orange = vec3(1.,.7,.2);

// convert pixel coordinate to complex plane coordinate
vec2 p2c(vec2 p) {
  vec2 wh2 = iResolution.xy/2.;
  float pr = min(wh2.x, wh2.y);
  vec2 c = (p - wh2)/pr;
  vec2 r = radius * vec2(cos(angle), sin(angle));
  return cmul(r,c) + center;
}


////////////////////////////////
// tiling
////////////////////////////////

// generators:
// number of generators
// normal
const int o_sphere = 0;
const int o_line = 1;
struct obj {
  int t;
  vec2 n;
  float d;
};
obj sphere(vec2 c, float r) {
  return obj(o_sphere, c, r);
}
obj line(vec2 n, float d) {
  return obj(o_line, n, d);
}

// I got these from https://bulatov.org/math/180110/index.html
// reflect
vec2 line_refl(vec2 A, vec2 N, float d) {
  return A - 2.*dot(A - d*N, N)*N;
}
// signed distance
float line_dist(vec2 A, vec2 N, float d) {
  return dot(A, N) - d;
}
vec2 sphere_invert(vec2 A, vec2 C, float r) {
  return C + r*r/abs2(A-C) * (A-C);
}
float sphere_dist(vec2 A, vec2 C, float r) {
  return sign(r)*(length(A-C)-abs(r));
}

vec2 inv(vec2 A, obj o) {
  if(o.t == o_sphere)
    return sphere_invert(A, o.n, o.d);
  return line_refl(A, o.n, o.d);
}
float dist(vec2 A, obj o) {
  if(o.t == o_sphere)
    return sphere_dist(A, o.n, o.d);
  return line_dist(A, o.n, o.d);
}

const int l = 9;
const int L = l+1;
obj[L] o;

float osc(float a, float lo, float hi) {
  return (1.-cos(a*2.*pi))/2.*(hi-lo) + lo;
}

int depth = 100;
vec3 f(vec2 z) {
  float da = 2.*pi/float(l)*osc(iTime/30.,1.,5.);
  float R = 1.;
  float r = R*sin(da/2.)/(1.+sin(da/2.));
  for(int k = 0; k < l; ++k) {
    float a = float(k)*da;
    o[k] = sphere(vec2(cos(a), sin(a))*(R-r), r);
  }
  o[l] = sphere(vec2(0,0), -R);

  int i, k;
  for(k = 0; k < L; ++k) {
    if(o[k].t == o_line)
      o[k].n = normalize(o[k].n);
  }

//  depth = int((1.+sin(iTime*3.))*float(depth)/2.+1.);
  int m;
  for(i = 0; i < depth; ++i) {
    for(k = 0; k < L; ++k) {
      ++m;
      float r = dist(z, o[k]);
      if(r < 0.) {
        z = inv(z, o[k]);
        break;
      }
    }
    if(k == L)
      break;
  }

  // outside
  if(i == depth)
    return white;

//  return phase(z);
//  return axies(z);

  float s = float(m)/float(depth);
  return hsv(float(i%2)/2.+.1, 1.-s, 1.);
}

const float linewidth = 3.; // in pixels

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
  vec2 z = p2c(fragCoord);
  fragColor = vec4(f(z), 1.);
  
  float pixelwidth = min(iResolution.x,iResolution.y)/2./radius;
  for(int k = 0; k < L; ++k) {
    float r = abs(dist(z, o[k]));
    float w = clamp(r/linewidth*pixelwidth, 0., 1.);
    fragColor = w*fragColor + (1.-w)*vec4(hsv(float(sign(o[k].d))/3., 1., 1.), 1.);
  }
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below 
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

